<?php

namespace App\models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'email', 'watsapp_number', 'city_id', 'area_id', 'fb_account', 'type');

    public function speciality()
    {
        return $this->belongsToMany('App\models\Speciality');
    }

    public function area()
    {
        return $this->belongsTo('App\models\Area', 'area_id');
    }

}